% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022
function [out, SR, dSR_dPI]  = static_solution_fixedpi(k,pistar,A,PARMS)

% 1) compute output from adjustable plants (using k-vector input)
outputA     = PARMS.PP'*(PARMS.eps.*(k.^PARMS.ALPHA));

% 2) find associated mu and phi values of k-vector
kmu         = PARMS.PP'*(k.^PARMS.ALPHA);
kphi        = outputA - PARMS.meaneps*kmu; %

% 3) find steady state value of mu (for non-adjusters)
mu_ss       = kmu;

% 4) find steady state value of phi (for non-adjusters)
phi_ss      = kphi.*pistar./(pistar + (1-PARMS.rho_eps)/PARMS.rho_eps);

% 5) compute output from non-adjustable plants
outputNA    = PARMS.meaneps*mu_ss + phi_ss;

% 6) compute total output
total       = A*(pistar.*outputA + (1-pistar).*outputNA)  - pistar^2/2*PARMS.F_upper;

% Function value: Negative for minimization
out         = -total;

mu_n        = mu_ss; % Stationary mu state
% Solow residual
SR          = A * (PARMS.meaneps*mu_n + kphi*pistar./(1-PARMS.rho_eps.*(1-pistar)) );
% Marginal effect on Solow residual
dSR_dPI     = A  * kphi*(1-PARMS.rho_eps) ./ (1-PARMS.rho_eps.*(1-pistar)).^2;



